#pragma once

/***************************************************************
 * This source files comes from the xLights project
 * https://www.xlights.org
 * https://github.com/smeighan/xLights
 * See the github commit history for a record of contributing
 * developers.
 * Copyright claimed based on commit dates recorded in Github
 * License: https://github.com/smeighan/xLights/blob/master/License.txt
 **************************************************************/

#include <string>
#include <list>

static std::list<std::list<std::string>> __projectorCodes =
{
    {
        "NAME", "PJLINK",
        "PROTOCOL", "PJLINK",
        "ON", "set_power_state 1",
        "OFF", "set_power_state 0",
        "RGB", "set_input INPUT_RGB",
        "VIDEO", "set_input INPUT_VIDEO",
        "DIGITAL", "set_input INPUT_DIGITAL",
        "STORAGE", "set_input INPUT_STORAGE",
        "NETWORK", "set_input INPUT_NETWORK",
        "VIDEO MUTE ON", "video_mute ON",
        "VIDEO MUTE OFF", "video_mute OFF",
        "AUDIO MUTE ON", "audio_mute ON",
        "AUDIO MUTE OFF", "audio_mute OFF",
        "IP", "",
        "PASSWORD", "",
        "PARAMETER", ""
    },
    {
        "NAME", "NETWORK_4352",
        "PROTOCOL", "TCP",
        "ON", "set_power_state 1",
        "OFF", "set_power_state 0",
        "IP", "",
        "PASSWORD", "",
        "PORT", "4352"
    },
    {
        "NAME", "EPSON_PWRLITE_93_NETWORK",
        "PROTOCOL", "TCP",
        "ON", "\\x49\\x4d\\x50\\x57\\x52\\x20\\x4f\\x4e\\x0d",
        "OFF", "\\x49\\x4d\\x50\\x57\\x52\\x20\\x4f\\x46\\x46\\x0d",
        "IP", "",
        "PASSWORD", "",
        "PORT", "3629"
    },
    {
        "NAME", "Hitatchi_CPX_1250",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x03\\x06\\x00\\xBA\\xD2\\x01\\x00\\x00\\x60\\x01\\x00",
        "OFF", "\\xBE\\xEF\\x03\\x06\\x00\\x2A\\xD3\\x01\\x00\\x00\\x60\\x00\\x00",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Sanyo_PLC_XP200L",
        "PROTOCOL", "SERIAL",
        "ON", "\\x43\\x30\\x30\\x0D",
        "OFF_IMMEDIATE", "\\x43\\x30\\x31\\x0D",
        "OFF_SLOW", "\\x43\\x30\\x32\\x0D",
        "INPUT1", "\\x43\\x30\\x35\\x0D",
        "INPUT2", "\\x43\\x30\\x36\\x0D",
        "INPUT3", "\\x43\\x30\\x37\\x0D",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Sanyo_PLC_HP7000L",
        "PROTOCOL", "SERIAL",
        "ON", "\\x43\\x30\\x30\\x0D",
        "OFF_IMMEDIATE", "\\x43\\x30\\x31\\x0D",
        "OFF_SLOW", "\\x43\\x30\\x32\\x0D",
        "INPUT1", "\\x43\\x30\\x35\\x0D",
        "INPUT2", "\\x43\\x30\\x36\\x0D",
        "INPUT3", "\\x43\\x30\\x37\\x0D",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Proxima_6850",
        "PROTOCOL", "SERIAL",
        "ON", "\\x31\\x11\\x3F",
        "OFF", "\\x31\\x11\\x3E",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_PT_AE900U",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x4f\\x4e",
        "OFF", "\\x50\\x4f\\x46\\x46",
        "VID", "\\x56\\x49\\x44",
        "RG1", "\\x52\\x47\\x31",
        "HDMI", "\\x48\\x44\\x4d",
        "SVIDEO", "\\x53\\x56\\x44",
        "YUV", "\\x59\\x55\\x56",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_PT_LB50NTU",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x4f\\x4e",
        "OFF", "\\x50\\x4f\\x46\\x46",
        "VID", "\\x56\\x49\\x44",
        "RG1", "\\x52\\x47\\x31",
        "RG2", "\\x52\\x47\\x32",
        "SVIDEO", "\\x53\\x56\\x44",
        "NWP", "\\x4e\\x57\\x50",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_PT_LB50U",
        "PROTOCOL", "SERIAL",
        "ON" , "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x50\\x4F\\x4E\\x03",
        "OFF", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x50\\x4F\\x46\\x03",
        "HD1", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x48\\x44\\x31\\x03",
        "HD2", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x48\\x44\\x32\\x03",
        "PC1", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x50\\x43\\x31\\x03",
        "PC2", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x50\\x43\\x32\\x03",
        "SVIDEO", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x53\\x56\\x44\\x03",
        "DVID", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x56\\x49\\x44\\x03",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_PT_DW6300",
        "PROTOCOL", "SERIAL",
        "ON" , "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x50\\x4F\\x4E\\x03",
        "OFF", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x50\\x4F\\x46\\x03",
        "HD1", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x48\\x44\\x31\03",
        "HD2", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x48\\x44\\x32\\x03",
        "PC1", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x50\\x43\\x31\\x03",
        "PC2", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x50\\x43\\x32\\x03",
        "SVIDEO", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x53\\x56\\x44\\x03",
        "DVID", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x49\\x49\\x53\\x3A\\x56\\x49\\x44\\x03",
        "SHUTTER_OFF", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x4F\\x53\\x48\\x3A\\x30\\x03",
        "SHUTTER_ON", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x4F\\x53\\x48\\x3A\\x31\\x03",
        "OSD_OFF", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x4F\\x4F\\x53\\x3A\\x30\\x03",
        "OSD_ON", "\\x02\\x41\\x44\\x5A\\x5A\\x3B\\x4F\\x4F\\x53\\x3A\\x31\\x03",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Sharp_PGD2500X",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x4f\\x57\\x52\\x20\\x20\\x20\\x31\\x0d",
        "OFF", "\\x50\\x4f\\x57\\x52\\x20\\x20\\x20\\x30\\x0d",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_RZ_670",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x4f\\x4e",
        "OFF", "\\x50\\x4f\\x46\\x46",
        "VID", "\\x56\\x49\\x44",
        "RG1", "\\x52\\x47\\x31",
        "RG2", "\\x52\\x47\\x32",
        "SVIDEO", "\\x53\\x56\\x44",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Casio_XJV1_HEX",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x57\\x52\\x31",
        "OFF", "\\x50\\x57\\x52\\x30",
        "RGB", "\\x53\\x52\\x43\\x30",
        "HDMI", "\\x53\\x52\\x43\\x37",
        "COMPONENT", "\\x53\\x52\\x43\\x31",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Casio_XJV1_ASCII",
        "PROTOCOL", "SERIAL",
        "ON", "(PWR1)",
        "OFF", "(PWR0)",
        "RGB", "(SRC0)",
        "HDMI", "(SRC7)",
        "AUTO", "(SRC6)",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Hitachi_CPX445",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x03\\x06\\x00\\xBA\\xD2\\x01\\x00\\x00\\x60\\x01\\x00",
        "OFF", "\\xBE\\xEF\\x03\\x06\\x00\\x2A\\xD3\\x01\\x00\\x00\\x60\\x00\\x00",
        "RGB1", "\\xBE\\xEF\\x03\\x06\\x00\\xFE\\xD2\\x01\\x00\\x00\\x20\\x00\\x00",
        "DVI", "\\xBE\\xEF\\x03\\x06\\x00\\x0E\\xD2\\x01\\x00\\x00\\x20\\x03\\x00",
        "COMPONENT", "\\xBE\\xEF\\x03\\x06\\x00\\xAE\\xD1\\x01\\x00\\x00\\x20\\x05\\x00",
        "VIDEO(RCA)", "\\xBE\\xEF\\x03\\x06\\x00\\x6E\\xD3\\x01\\x00\\x00\\x20\\x01\\x00",
        "VIDEO(S)", "\\xBE\\xEF\\x03\\x06\\x00\\x9E\\xD3\\x01\\x00\\x00\\x20\\x02\\x00",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Dell_MP_1200 ",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x10\\x05\\x00\\xC6\\xFF\\x11\\x11\\x01\\x00\\x01",
        "OFF", "\\xBE\\xEF\\x10\\x05\\x00\\x0C\\x3E\\x11\\x11\\x01\\x00\\x18",
        "VGA", "\\xBE\\xEF\\x10\\x05\\x00\\xCC\\xFF\\x11\\x11\\x01\\x00\\x19",
        "SVIDEO", "\\xBE\\xEF\\x10\\x05\\x00\\x1F\\xBE\\x11\\x11\\x01\\x00\\x22",
        "COMPOSITE", "\\xBE\\xEF\\x10\\x05\\x00\\xDF\\x7F\\x11\\x11\\x01\\x00\\x23",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Dell_2300_MP ",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x10\\x05\\x00\\xC7\\xBF\\x11\\x11\\x01\\x00\\x02",
        "OFF", "\\xBE\\xEF\\x10\\x05\\x00\\x0C\\x3E\\x11\\x11\\x01\\x00\\x18",
        "VGA", "\\xBE\\xEF\\x10\\x05\\x00\\xCC\\xFF\\x11\\x11\\x01\\x00\\x19",
        "SVIDEO", "\\xBE\\xEF\\x10\\x05\\x00\\x1F\\xBE\\x11\\x11\\x01\\x00\\x22",
        "COMPOSITE", "\\xBE\\xEF\\x10\\x05\\x00\\xDF\\x7F\\x11\\x11\\x01\\x00\\x23",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Dell_4210x",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x10\\x05\\x00\\xC6\\xFF\\x11\\x11\\x01\\x00\\x01",
        "OFF", "\\xBE\\xEF\\x10\\x05\\x00\\x0C\\x3E\\x11\\x11\\x01\\x00\\x18",
        "VGA", "\\xBE\\xEF\\x10\\x05\\x00\\xCC\\xFF\\x11\\x11\\x01\\x00\\x19",
        "SVIDEO", "\\xBE\\xEF\\x10\\x05\\x00\\x1F\\xBE\\x11\\x11\\x01\\x00\\x22",
        "COMPOSITE", "\\xBE\\xEF\\x10\\x05\\x00\\xDF\\x7F\\x11\\x11\\x01\\x00\\x23",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Dell_2400MP",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x10\\x05\\x00\\xC6\\xFF\\x11\\x11\\x01\\x00\\x01",
        "OFF", "\\xBE\\xEF\\x10\\x05\\x00\\x0C\\x3E\\x11\\x11\\x01\\x00\\x18",
        "VGA", "\\xBE\\xEF\\x10\\x05\\x00\\xCC\\xFF\\x11\\x11\\x01\\x00\\x19",
        "SVIDEO", "\\xBE\\xEF\\x10\\x05\\x00\\x1F\\xBE\\x11\\x11\\x01\\x00\\x22",
        "COMPOSITE", "\\xBE\\xEF\\x10\\x05\\x00\\xDF\\x7F\\x11\\x11\\x01\\x00\\x23",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "EPSON_EH_TW5900",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x57\\x52\\x20\\x4f\\x4e\\x0d\\x0a",
        "OFF", "\\x50\\x57\\x52\\x20\\x4f\\x46\\x46\\x0d\\x0a",
        "HDMI1", "\\x53\\x4f\\x55\\x52\\x43\\x45\\x20\\x33\\x30\\x0d\\x0a",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "EPSON_PWRLITE_6110i",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x4f\\x57\\x52\\x20\\x4f\\x4e",
        "OFF", "\\x50\\x4f\\x57\\x52\\x20\\x4f\\x46\\x46",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "EPSON_PWRLITE_500_PWRLITE_93",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x57\\x52\\x20\\x4f\\x4e",
        "OFF", "\\x50\\x57\\x52\\x20\\x4f\\x46\\x46",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Viewsonic_PJD5153",
        "PROTOCOL", "SERIAL",
        "ON", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x00\\x00\\x5D",
        "OFF", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x01\\x00\\x5E",
        "BAUD_RATE", "115200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Viewsonic_PJD5255",
        "PROTOCOL", "SERIAL",
        "ON", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x00\\x00\\x5D",
        "OFF", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x01\\x00\\x5E",
        "VGA", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x00\\x60",
        "VGA2", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x08\\x68",
        "COMPOSITE", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x05\\x65",
        "SVIDEO", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x06\\x66",
        "HDMI", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x03\\x63",
        "HDMI2", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x03\\x67",
        "BAUD_RATE", "115200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Viewsonic_PJD5555w",
        "PROTOCOL", "SERIAL",
        "ON", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x00\\x00\\x5D",
        "OFF", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x01\\x00\\x5E",
        "VGA", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x00\\x60",
        "VGA2", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x08\\x68",
        "COMPOSITE", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x05\\x65",
        "SVIDEO", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x06\\x66",
        "HDMI", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x03\\x63",
        "BAUD_RATE", "115200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Viewsonic_PDJ5132",
        "PROTOCOL", "SERIAL",
        "ON", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x00\\x00\\x5D",
        "OFF", "\\x06\\x14\\x00\\x04\\x00\\x34\\x11\\x01\\x00\\x5E",
        "VGA", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x00\\x60",
        "VGA2", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x08\\x68",
        "COMPOSITE", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x05\\x65",
        "SVIDEO", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x06\\x66",
        "HDMI", "\\x06\\x14\\x00\\x04\\x00\\x34\\x13\\x01\\x03\\x63",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "EPSON_EX5200",
        "PROTOCOL", "SERIAL",
        "ON", "\\x50\\x57\\x52\\x20\\x4f\\x4e",
        "OFF", "\\x50\\x57\\x52\\x20\\x4f\\x46\\x46",
        "VIDEO", "\\x30\\x30\\x5F\\x76\\x31",
        "INPUT1", "\\x49\\x4e\\x50\\x55\\x54\\x31",
        "INPUT3", "\\x49\\x4e\\x50\\x55\\x54\\x33",
        "VIDEO", "\\x56\\x49\\x44\\x45\\x4f",
        "VIDEO(RCA)", "\\x56\\x49\\x44\\x45\\x4f\\x28\\x52\\x43\\x41\\x29",
        "VIDEO(S)", "\\x56\\x49\\x44\\x45\\x4f\\x28\\x53\\x29",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Mitsubishi_FD730U",
        "PROTOCOL", "SERIAL",
        "ON", "\\x30\\x30\\x21\\x0D",
        "OFF", "\\x30\\x30\\x22\\x0D",
        "VIDEO", "\\x30\\x30\\x5F\\x76\\x31",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "BenQ_PB7200",
        "PROTOCOL", "SERIAL",
        "ON", "\\xBE\\xEF\\x03\\x19\\x00\\x83\\xA9\\x01\\x23\\x03\\xCC\\xCC\\xFF\\xFF\\xFF\\xFF\\x01\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "OFF", "\\xBE\\xEF\\x03\\x19\\x00\\x13\\x68\\x01\\x23\\x03\\xCC\\xCC\\xFF\\xFF\\xFF\\xFF\\x00\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "VIDEO_IN", "\\xBE\\xEF\\x03\\x19\\x00\\x9B\\x88\\x01\\xDA\\x02\\xCC\\xCC\\x00\\x00\\x00\\x00\\x05\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "PC1_IN", "\\xBE\\xEF\\x03\\x19\\x00\\xC8\\x4B\\x01\\xDA\\x02\\xCC\\xCC\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "PC2_IN", "\\xBE\\xEF\\x03\\x19\\x00\\x58\\x8A\\x01\\xDA\\x02\\xCC\\xCC\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "SVIDEO_IN", "\\xBE\\xEF\\x03\\x19\\x00\\x0B\\x49\\x01\\xDA\\x02\\xCC\\xCC\\x00\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC\\xCC",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "BenQ_MX819ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x0D\\x2A\\x70\\x6F\\x77\\x3D\\x6F\\x6E\\x23\\x0D",
        "OFF", "\\x0D\\x2A\\x70\\x6F\\x77\\x3D\\x6F\\x66\\x66\\x23\\x0D",
        "YPBR_1", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x52\\x47\\x42\\x23\\x0D", //2a 73 6f 75 72 3d 52 47 42 23	
        "YPBR_2", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x52\\x47\\x42\\x32\\x23\\x0D", //2a 73 6f 75 72 3d 52 47 42 32 23
        "COMPONENT", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x79\\x70\\x62\\x72\\x23\\x0D", //2a 73 6f 75 72 3d 79 70 62 72 23
        "DVI_A", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x64\\x76\\x69\\x41\\x23\\x0D", //2a 73 6f 75 72 3d 64 76 69 41 23
        "DVI_D", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x64\\x76\\x69\\x44\\x23\\x0D", //2a 73 6f 75 72 3d 64 76 69 44 23
        "HDMI_1", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x68\\x64\\x6D\\x69\\x23\\x0D", //2a 73 6f 75 72 3d 68 64 6d 69 23	
        "HDMI_2", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x68\\x64\\x6D\\x69\\x32\\x23\\x0D", //2a 73 6f 75 72 3d 68 64 6d 69 32 23
        "VIDEO", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x76\\x69\\x64\\x23\\x0D", //2a 73 6f 75 72 3d 76 69 64 23
        "SVIDEO", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x73\\x76\\x69\\x64\\x23\\x0D", //2a 73 6f 75 72 3d 73 76 69 64 23	
        "BAUD_RATE", "115200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "BenQ_W770ST_MS510",
        "PROTOCOL", "SERIAL",
        "ON", "\\x0D\\x2A\\x70\\x6F\\x77\\x3D\\x6F\\x6E\\x23\\x0D",
        "OFF", "\\x0D\\x2A\\x70\\x6F\\x77\\x3D\\x6F\\x66\\x66\\x23\\x0D",
        "VIDEO", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x76\\x69\\x64\\x23\\x0D",
        "HDMI_1", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x68\\x64\\x6D\\x69\\x23\\x0D",
        "HDMI_2", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x68\\x64\\x6D\\x69\\x32\\x23\\x0D",
        "PC", "\\x0D\\x2A\\x73\\x6F\\x75\\x72\\x3D\\x52\\x47\\x42\\x23\\x0D",
        "STATUS", "\\x0D\\x2A\\x70\\x6F\\x77\\x3D\\x3F\\x23\\x0D",
        "BLANK-ON", "\\x0d\\x2a\\x62\\x6c\\x61\\x6e\\x6b\\x3d\\x6f\\x6e\\x23\\x0d",
        "BLANK-OFF", "\\x0d\\x2a\\x62\\x6c\\x61\\x6e\\x6b\\x3d\\x6f\\x66\\x66\\x23\\x0d",
        "BAUD_RATE", "115200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "BenQ_MX613ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x38\\x30\\x31\\x73\\x21\\x30\\x30\\x31\\x0D",
        "OFF", "\\x38\\x30\\x31\\x73\\x21\\x30\\x30\\x32\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_NP400",
        "PROTOCOL", "SERIAL",
        "ON", "\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF", "\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "PC1", "\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "PC2", "\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "PC3", "\\x02\\x03\\x00\\x00\\x02\\x01\\x1A\\x22",
        "VIDEO", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "19200",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_MT1050",
        "PROTOCOL", "SERIAL",
        "ON" , 		"\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF" , 	"\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN" , "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "RGB1" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "RGB2" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "VIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "38400",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_V260X",
        "PROTOCOL", "SERIAL",
        "ON" , 		"\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF" , 	"\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN" , "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "PC1" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "PC2" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "VIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "38400",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_NP4001",
        "PROTOCOL", "SERIAL",
        "ON" , 		"\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF" , 	"\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN" , "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "PC1" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "PC2" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "PC3" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x1A\\x22",
        "VIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO" , 	"\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "38400",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_NP400_NETWORK",
        "PROTOCOL", "TCP",
        "IP", "",
        "PASSWORD", "",
        "PORT", "7142",
        "ON",  "\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF", "\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "PC1", "\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "PC2", "\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "PC3", "\\x02\\x03\\x00\\x00\\x02\\x01\\x1A\\x22",
        "VIDEO", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO", "\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13"
    },
    {
        "NAME", "NEC_GENERIC_NEC_MT1065",
        "PROTOCOL", "SERIAL",
        "ON", "\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF", "\\x02\\x01\\x00\\x00\\x00\\x03",
        "VIDEO_IN", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "PC1-RGB1", "\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "PC2-RGB2", "\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "VIDEO", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "SVIDEO", "\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "DVI", "\\x02\\x03\\x00\\x00\\x02\\x01\\x1A\\x22",
        "HDMI", "\\x02\\x03\\x00\\x00\\x02\\x01\\x1A\\x22",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "38400",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_PA622u",
        "PROTOCOL", "SERIAL",
        "ON", "\\x02\\x00\\x00\\x00\\x00\\x02",
        "OFF", "\\x02\\x01\\x00\\x00\\x00\\x03",
        "HDMI_IN1", "\\x02\\x03\\x00\\x00\\x02\\x01\\xA1\\xA9",
        "HDMI_IN2", "\\x02\\x03\\x00\\x00\\x02\\x01\\xA2\\xAA",
        "Displayport", "\\x02\\x03\\x00\\x00\\x02\\x01\\xA6\\xAE",
        "VIDEO_BNC", "\\x02\\x03\\x00\\x00\\x02\\x01\\x02\\x0A",
        "VIDEO_CV", "\\x02\\x03\\x00\\x00\\x02\\x01\\x06\\x0E",
        "VIDEO_YC", "\\x02\\x03\\x00\\x00\\x02\\x01\\x0B\\x13",
        "PC1_IN", "\\x02\\x03\\x00\\x00\\x02\\x01\\x01\\x09",
        "HDBaseT", "\\x02\\x03\\x00\\x00\\x02\\x01\\x20\\x28",
        "PICTURE_OFF", "\\x02\\x10\\x00\\x00\\x00\\x12",
        "PICTURE_ON", "\\x02\\x11\\x00\\x00\\x00\\x13",
        "BAUD_RATE", "38400",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_150S",
        "PROTOCOL", "SERIAL",
        "ON", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x30\\x0D",
        "VGA1", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x35\\x0D",
        "VGA2", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x36\\x0D",
        "SCART", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x37\\x0D",
        "VGA_1_COMPONENT", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x38\\x0D",
        "VGA_2_COMPONENT", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x33\\x0D",
        "VIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x30\\x0D",
        "SVIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_X600",
        "PROTOCOL", "SERIAL",
        "ON", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x30\\x0D",
        "HDMI", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x0D",
        "HDMI2", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\\x35\\x0D",
        "VGA1", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x35\\x0D",
        "VGA2", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x36\\x0D",
        "VIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x30\\x0D",
        "SVIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_H181X_GT760",
        "PROTOCOL", "SERIAL",
        "ON",          "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF",         "\\x7E\\x30\\x30\\x30\\x30\\x20\\x30\\x0D",
        "HDMI",        "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x0D",
        "VGA",         "\\x7E\\x30\\x30\\x31\\x32\\x20\\x35\\x0D",
        "VGA2",        "\\x7E\\x30\\x30\\x31\\x32\\x20\\x36\\x0D",
        "SVIDEO",      "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "VIDEO",       "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x30\\x0D",
        "MUTE ON",     "\\x7E\\x30\\x30\\x30\\x33\\x20\\x31\\x0D",
        "MUTE OFF",    "\\x7E\\x30\\x30\\x30\\x33\\x20\\x30\\x0D",
        "AV MUTE ON",  "\\x7E\\x30\\x30\\x30\\x32\\x20\\x31\\x0D",
        "AV MUTE OFF", "\\x7E\\x30\\x30\\x30\\x32\\x20\\x30\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_XW305_ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x30\\x0D",
        "HDMI", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x0D",
        "VGA_1", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x35\\x0D",
        "VGA_2", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x36\\x0D",
        "SVIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "VIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x30\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_XW306_ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x30\\x0D",
        "VGA_1_SCART", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x37\\x0D",
        "VGA_1_COMPONENT", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x38\\x0D",
        "VGA_2_COMPONENT", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "VIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x30\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Optoma_EX525_ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x31\\x0D",
        "OFF", "\\x7E\\x30\\x30\\x30\\x30\\x20\\x32\\x0D",
        "DVI_D", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x32\\x0D",
        "DVI_A", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x33\\x0D",
        "VGA", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x35\\x0D",
        "VIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x31\\x0D",
        "SVIDEO", "\\x7E\\x30\\x30\\x31\\x32\\x20\\x39\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Mitsubishi_EX320U_EW330U_EX320U_ST",
        "PROTOCOL", "SERIAL",
        "ON", "\\x30\\x30\\x21\\x0D",
        "OFF", "\\x30\\x30\\x22\\x0D",
        "VIDEO", "\\x30\\x30\\x5F\\x76\\x31\\x0D",
        "HDMI", "\\x30\\x30\\x5F\\x64\\x31\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Panasonic_PT_F200",
        "PROTOCOL", "SERIAL",
        "ON", "\\x02\\x50\\x4F\\x4E\\x03",
        "OFF", "\\x02\\x50\\x4F\\x46\\x03",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "NEC_LCD4000",
        "PROTOCOL", "SERIAL",
        "ON", "\\x30\\x30\\x21\\x0D",
        "OFF", "\\x30\\x30\\x22\\x0D",
        "RGB1", "\\x30\\x30\\x21\\x0D\\x5F\\x72\\x31\\x0D",
        "RGB2", "\\x30\\x30\\x21\\x0D\\x5F\\x72\\x32\\x0D",
        "RGB3", "\\x30\\x30\\x21\\x0D\\x5F\\x72\\x33\\x0D",
        "VIDEO", "\\x30\\x30\\x21\\x0D\\x5F\\x76\\x31\\x0D",
        "DVD", "\\x30\\x30\\x21\\x0D\\x5F\\x76\\x32\\x0D",
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
    {
        "NAME", "Samsung_Commercial_Flat_Panel_MDC",
        "PROTOCOL", "SERIAL",
        "ON", "\\xAA\\x11\\xFE\\x01\\x01\\x11",
        "OFF", "\\xAA\\x11\\xFE\\x01\\x00\\x10",
        "SVIDEO", "\\xAA\\x14\\xFE\\x01\\x04\\x17",//not available on test tv
        "VIDEO", "\\xAA\\x14\\xFE\\x01\\x0C\\x1F",
        "YPbPr", "\\xAA\\x14\\xFE\\x01\\x08\\x1B",
        "PC", "\\xAA\\x14\\xFE\\x01\\x14\\x27",
        "DVIVid", "\\xAA\\x14\\xFE\\x01\\x1F\\x32",
        "PC1", "\\xAA\\x14\\xFE\\x01\\x15\\x28",//not available on test tv
        "PC2", "\\xAA\\x14\\xFE\\x01\\x16\\x29",//not available on test tv
        "DVID", "\\xAA\\x14\\xFE\\x01\\x18\\x2B",
        "BNC", "\\xAA\\x14\\xFE\\x01\\x1E\\x31",
        "MagicNet", "\\xAA\\x14\\xFE\\x01\\x20\\x33",//not available on test tv
        "HDMI", "\\xAA\\x14\\xFE\\x01\\x21\\x34",
        "ATV", "\\xAA\\x14\\xFE\\x01\\x30\\x43",//not available on test tv
        "DTV", "\\xAA\\x14\\xFE\\x01\\x40\\x53",//not available on test tv
        "BAUD_RATE", "9600",
        "CHAR_BITS", "8",
        "STOP_BITS", "1",
        "PARITY", "NONE"
    },
};
